﻿(function ($) {
    $.widget("a4.a4tabs", {
        options: {},
        _create: function () {
            this.element.addClass("tabs-container");

            $("[data-tab]", this.element).hide();

            var tabsList = $("<ul/>");

            $("div[data-tab]", this.element).each(function () {
                $(this).addClass("tab-content");

                var tab = $("<li />", { "data-tab": $(this).attr("data-tab"), "class": "tab" }).append($(this).attr("data-tab-title"));
                tabsList.append(tab).append(" ");
            });

            this.element.prepend($("<div />", { "class": "tabs primary" }).append(tabsList));

            this._bindEvents();

            if (this.options.defaultTab == undefined || this.options.defaultTab.length === 0 || this.options.defaultTab === "") {
                var selectedTab = $(".tab", this.element).first().attr("data-tab");
            }
            else {
                var selectedTab = this.options.defaultTab;
            }

            this._changeTab(selectedTab);
        },
        destroy: function () {
            $.Widget.prototype.destroy.call(this);
        },
        _bindEvents: function () {
            var self = this;

            this.element.on("click", ".tabs .tab", function () {
                self._changeTab($(this).attr("data-tab"));
            });
        },
        _loadTab: function (tabId) {
            var tab = $(".tabs .tab[data-tab='" + tabId + "']", this.element);
            var tabContent = $(".tab-content[data-tab='" + tabId + "']", self.element);
            var defer = new $.Deferred();

            //Load tab content
            defer.resolve();

            tab.addClass("loaded");

            this._trigger("load", null, { id: tabId, tab: tabContent });

            return defer.promise();
        },
        _changeTab: function (tabId) {
            var self = this;
            var tab = $(".tabs .tab[data-tab='" + tabId + "']", this.element);
            var loadPromise;

            if (!tab.hasClass("loaded")) {
                loadPromise = this._loadTab(tabId);
            }

            $.when(loadPromise).done(function () {
                $(".tabs .tab.selected", self.element).removeClass("selected");
                tab.addClass("selected");

                var tabContent = $(".tab-content[data-tab='" + tabId + "']", self.element);

                $(".tab-content[data-tab]", self.element).hide();
                tabContent.show();

                self.currentTab = tabId;

                self._trigger("change", null, { id: tabId, tab: tabContent });
            });
        },
        changeTab: function (tabId) {
            this._changeTab(tabId);
        },
        disableTab: function (tabId){
            var tab = $(".tabs .tab[data-tab='" + tabId + "']");
            tab.prop("disabled", true);
            tab.addClass("disabled");
        },
        enableTab: function (tabId){
        var tab = $(".tabs .tab[data-tab='" + tabId + "']");
        tab.prop("disabled", false);
        tab.removeClass("disabled");
    }
    });
}(jQuery));